/* A program to combine TLIB Version Control journal file records, appending
   the ".N" additional comment lines to the main journal line's final field.

BLD_JOIN.CMD:

i:\c6\binp\cl /c /AS /W4 /G2 /BATCH /J /Os /Zi /Gs jourjoin.c
i:\c6\binb\link /PM:VIO jourjoin.obj, jourjoin.exe,, /NOD:SLIBCA /NOD:SLIBCE SLIBCAP /NOI /BATCH /FAR /PACKC /MAP;
i:\c6\binb\bind jourjoin doscalls.lib

  Copyright 2000, Burton Systems Software.  All Rights Reserved.

  +=>keyflag<=-- "%n, version %v, %d "
  "JOURJOIN.C, version 2, 12-Oct-00 "

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

char tmp[20] = "PatchPoint= \0";
#define join_with (tmp+11)  /* defaults to a single blank */
int len_join_str = 1;  /* strlen(join_with) */

#define LINELIMIT 10000
int line_limit = LINELIMIT;



/* -----------------------------------------------------

Sample input:

7-Jul-2000,10:23:10,U,N,,x:\tlib\redist9b.h$m,REDIST5.TXT,,3,REDIST5.TXT,,,"13-May-98,13:52:46 This is the written version (somewhat"
,,,,,,,,,,,,"revised & expanded) of my remarks at the May 13, 1998 Public Hearing"
,,,,,,,,,,,,"on Congressional Redistricting."


Sample output:

7-Jul-2000,10:23:10,U,N,,x:\tlib\redist9b.h$m,REDIST5.TXT,,3,REDIST5.TXT,,,"13-May-98,13:52:46 This is the written version (somewhat revised & expanded) of my remarks at the May 13, 1998 Public Hearing on Congressional Redistricting."

----------------------------------------------------- */

int main (int argc, char *argv[])
  {
   int rc, write_error;
   char * write_errstr;
   long int outp_recs=0, inp_recs=0, overflowed_rec=0;
   char * progname;
   FILE *inp, *outp;
   char * linebuf1, *linebuf2;  /* malloc'd to 10K each */
   char * ptr2;
   int len1, len2;

    len_join_str = strlen( join_with );  /* 1 unless patched at patch point */

    progname = argv[0];
    argv++;
    argc--;

    while ((argc > 1) && ('-' == argv[0][0] ))
      { /* got an option! */
        if (!stricmp("-TAB",argv[0]))
          {
            strcpy( join_with, "\t" );
            argv++;
            argc--;
          }
        else if (!stricmp("-SPACE",argv[0]))
          { /* this is the default, unless program is patched at patch point */
            strcpy( join_with, " " );
            argv++;
            argc--;
          }
        else if (!stricmp("-TILDE",argv[0]))
          {
            strcpy( join_with, "~" );
            argv++;
            argc--;
          }
        else if (!stricmp("-2SPACES",argv[0]))
          {
            strcpy( join_with, "  " );
            argv++;
            argc--;
          }
        else
          {
            fprintf( stderr, "ERROR: unrecognized option, '%s'\n"
                     "Run %s without any options for help.\n",
                     argv[0], progname );
            return 1;
          }
      }/*while*/

    if (argc != 2)
      {
        printf("JOURJOIN -- Copyright 2000, Burton Systems Software.  All Rights Reserved.\n"
               "\n"
               "Combine comment lines in a TLIB Journal File, appending the additional\n"
               "comment lines to the comment field in the main record for U (Update)\n"
               "and N (New library) commands.  This can simplify importing TLIB journal\n"
               "files into some database programs.\n"
               "\n"
               "Usage:\n"
               "\n"
               "   %s {option} JOURNAL.DAT JOURNAL.CSV\n"
               "\n"
               "where JOURNAL.DAT is the regular journal file, created by TLIB,\n"
               "and JOURNAL.CSV is the output file, in which additional comment-line\n"
               "records have been merged into the comment field of the associated\n"
               "U or N command record.\n"
               "\n"
               "Note: this can result in an output file with rather long lines.\n"
               "\n"
               "{option} can be omitted, to combine comment lines with one blank between\n"
               "them, or you may specify {option} as '-2SPACES', '-TILDE', or '-TAB' to\n"
               "insert the indicated separator character(s), instead.\n",
               progname );
        return 1;
      }

    /* At this point, argv[0] is the input file name,
       and argv[1] is the output file name */

    inp = fopen( argv[0], "rt" );  /* for Unix omit the 't' */
    if (!inp)
      {
        fprintf( stderr, "ERROR: can't open '%s' for input: %s\n",
                 argv[0], strerror(errno) );
        return 1;
      }

    /* delete output file first, just to be sure, in case it is on a
       buggy MARS_NWE network server, which doesn't properly truncate. */
#if 1
    remove( argv[1] );  /* ANSI version */
#else
    _unlink( argv[1] );  /* Unix version */
#endif

    /* then create output file */
    outp = fopen( argv[1], "wt" );  /* for Unix omit the 't' */
    if (!outp)
      {
        fprintf( stderr, "ERROR: can't open '%s' for output: %s\n",
                 argv[1], strerror(errno) );
        return 1;
      }

    linebuf1 = malloc( LINELIMIT+4 );
    linebuf2 = malloc( LINELIMIT+4 );
    if (!linebuf2)
      {
        fprintf( stderr, "ERROR: could not malloc 20K buffer.\n" );
        return 1;
      }
    linebuf1[0] = linebuf2[0] = '\0';

    inp_recs = outp_recs = 0;
    write_error = 0;
    write_errstr = "";
    while (fgets( linebuf2, LINELIMIT, inp ))
      {
        inp_recs++;
        /* check for additional-comment-line record: */
        if (','==linebuf2[0])
          { /* Comment-line record, with 9-12 (usually 12) leading commas.
               First, find start of comment (usually in column 13):  */
            ptr2 = linebuf2;
            while (',' == *ptr2)
                ptr2++;
            /* ptr2 should now point to '"' at start of comment */
            if ('"' == ptr2[0])
              {
                len1 = strlen( linebuf1 );
                if ((len1 >= 11) && ('"' == linebuf1[len1-2]))
                  { /* previous line is U or N cmd with quoted comment field at end */
                    len2 = strlen( ptr2 );
                    if ((len1+len2+len_join_str-3) >= line_limit)
                      { /* HUGE comment!  It would overflow our buffer! */
                        if (0L==overflowed_rec)
                            overflowed_rec = inp_recs;
                            /* note the line number, for subsequent error msg */
                      }
                    else
                      { /* combine comment of line2 into final field of line1 */
                        strcpy( linebuf1+len1-2, join_with );  /* overwrites trailing '"' and '\n' */
                        strcpy( linebuf1+len1-2+len_join_str, ptr2+1 );
                        linebuf2[0] = '\0';
                      }
                  }
                /* else
                    fprintf( stderr, "Error in input format: Can't merge input line %ld with previous line\n"
                             "because previous line doesn't record a U or N command with comments.\n", inp_recs );
                */
              }
            /* else
                fprintf( stderr, "Error in input format: record %ld begins with comma but commas\n"
                         "aren't followed by a quoted comment string.\n", inp_recs );
            */
          }
        /* if we didn't combine the two lines, then write previous line: */
        if (linebuf2[0])
          {
            if (linebuf1[0])
              {
                outp_recs++;
                rc = fputs( linebuf1, outp );
                if (EOF==rc)
                    goto err_writing;
              }
            strcpy( linebuf1, linebuf2 );
            linebuf2[0] = '\0';
          }
      }/*for*/

    /* write final line */
    if (linebuf1[0])
      {
        outp_recs++;
        rc = fputs( linebuf1, outp );
        if (EOF==rc)
          {
      err_writing:
            write_error = errno;
            if (!write_error)
                write_error = ENOSPC; /* No space left on device */
            write_errstr = strerror(write_error);
            if ((!write_errstr) || !write_errstr[0])
                write_errstr = "No space left on device";
          }
      }


    fclose( outp );
    fclose( inp );

    if (write_error)
      {
        fprintf( stderr, "ERROR: failure writing '%s': %s\n",
                 progname, write_errstr );
      }
    else
      {
        if (overflowed_rec)
            fprintf( stderr, "Warning: comment field for input record no. %ld was too long to be\n"
                     "fully combined.\n", overflowed_rec );
        printf( "Created %s, %ld output records (from %ld input records).\n",
                argv[1], outp_recs, inp_recs );
      }

    return 0;
  } /*main*/
